' RGB LED matrix test program.bas
' an MMBasic program written to test the way an RGB LED matrix module
' based on the WorldSemi WS2812B 'intelligent' RGB LED can be driven
' by a Micromite, using Peter Mathers' embedded C routine
' WS2812.Pulses (modified to suit the WS2812B) - which can be found
' at the end of this program in hex form.
'
' written by Jim Rowe for Silicon Chip
' last revised 25 September 2019 at 2:05 pm
' *********************************************************************
OPTION DEFAULT NONE 
OPTION EXPLICIT 
 
' Initialise required global variables depending on the number of LEDs
' and set up the output pin and CPU speed 
' 
const LED_PIN = 9   ' pin to connect to the data-in on the WS2812B module 
const NUMLEDS = 64  ' number of LEDs in the WS2812B module chain 
setpin LED_PIN,DOUT ' set the data pin as an output 
DIM INTEGER colours(NUMLEDS-1) 'set up array to hold the colours for each LED
'                              ' i.e., colours(0) to colours(NUMLEDS-1)
DIM integer i, j
DIM INTegER green = 40    ' maximum green level for low current operation
DIM INTEGER red = 40      ' maximum red level for low current operation
DIM INTEGER blue = 40     ' maximum blue level for low current operation
DIM INTEGER greenness
DIM INTEGER redness
DIM INTEGER blueness
'
PIN(LED_PIN) = 0  ' set LED_PIN low to begin

' useful colour recipes:
' white = GREEN, RED, BLUE
' green = GREEN, 0, 0
' yellow = GREEN, RED, 0
' red = 0, RED, 0
' magenta = 0, RED, BLUE
' blue = 0, 0, BLUE
' cyan = GREEN, 0, BLUE
' black = 0, 0, 0

' main program loop starts here
DO
  ' first set all of the LED colours to a chosen colour
  FOR i = 0 TO 7
    WS2812.setcolour(i, GREEn, RED, BLUE) 'first row white
  NEXT i

  FOR i = 8 TO 15
    WS2812.setcolour(i, GREEN, RED, 0)  ' next row yellow
  NEXT i
  
  FOR i = 16 TO 23
    WS2812.setcolour(i, GREEN, 0, 0)  ' next row green
  NEXT i
  
  FOR i = 24 TO 31
    WS2812.setcolour(i, GREEN, 0, BLUE)  ' next row cyan
  NEXT i
  
  FOR i = 32 TO 39
    WS2812.setcolour(i, 0, 0, BLUE)   ' next row blue
  NEXT i 
  
  FOR i = 40 TO 47
    WS2812.setcolour(i, 0, RED, BLUE)  ' next row magenta
  NEXT i
  
  FOR i = 48 TO 55
    WS2812.setcolour(i, 0, RED, 0)  ' next row red
  NEXT i
  
    FOR i = 56 TO 63
    WS2812.setcolour(i, 20, 20, 20)  ' last row grey
  NEXT i 
   
  ' now send that colour pattern out to the LEDs
  WS2812.Pulses(NUMLEDS,LED_PIN,colours())
  
  PAUSE 5000    ' wait for 5 seconds
  ' next set all LED colours to (0,0,0) for them all to go dark
  FOR i = 0 to (NUMLEDS-1)
    WS2812.setcolour(i, 0, 0, 0)
  NEXT i
  
    ' & send that black array to the LEDs
  WS2812.Pulses(NUMLEDS,LED_PIN,colours())
  
  Pause 5000    ' wait for another 5 seconds
    
LOOP

' *********************************************************************
' WS2812.setcolour: A subroutine to load the colour array element for a
' specific LED with the green, red, and blue components. Each colour
' component is one byte, so each colour array element has a total of 24
' bits. The subroutine is called like this:
' WS2812.setcolour(led as int, greenness as int, redness as int, blueness as int) 
' 
sub WS2812.setcolour(led as integer, greenness as integer, redness as integer, blueness as integer) 
  colours(led) = ((greenness and &HFF)<<16) + ((redness and &HFF)<<8) + (blueness and &HFF) 
end sub
'
' *********************************************************************
' WS2812.getcolour: A subroutine to get the green, red, and blue
' components for a specific LED from the colour array. Called thus: 
' WS2812.getcolour(led as int, greenness as int, redness as int, blueness as int) 
' 
sub WS2812.getcolour(led as integer, greenness as integer, redness as integer, blueness as integer) 
  greenness = colours(led)>>16  ' extract green value by moving down by 16 bits
  redness = (colours(led)>>8) and &HFF ' then get red value by moving down by 8
                                       ' bits, masking off all but lowest 8 bits
  blueness = colours(led) and &HFF     ' then get blue value as lowest 8 bits
end sub 
' 
' *********************************************************************
' CSUB WS2812.Pulses - an embedded C routine written by P. Mathers, used
' to drive RGB LED modules based on the WS2812 intelligent LED
' called by WS2812.Pulses(NUMLEDS as int, LED_PIN as int, colours() as int)
' where NUMLEDS is the number of LEDs, LED_PIN is the Micromite pin used
' to drive the serial data input pin of the module, and colours() is
' the array used to hold the colours to be displayed by each LED.
' Note that each element of the colours() array holds 24 bits of data,
' with the first 8 bits representing the green level, the next 
' 8 bits the red level and the final 8 bits the blue level.

Csub WS2812.Pulses 
00000000 
27BDFFB8 AFBF0044 AFBE0040 AFB7003C AFB60038 AFB50034 AFB40030 AFB3002C 
AFB20028 AFB10024 AFB00020 3C169D00 8EC20000 3C120057 3652316E 8C420000 
3C100026 261025A0 0052001B 024001F4 3C130026 367325A0 3C110057 2631316E 
AFA5004C 0080A821 8EC30028 8CA40000 AFA60050 00009012 2652FFFF 0050001B 
020001F4 00008012 2610FFFF 0053001B 026001F4 00009812 0051001B 022001F4 
0060F809 00008812 8EA50000 8EC30040 000520C0 00052940 00A42023 24050001 
00452804 0060F809 AFA50018 AFA20010 8EA30000 8EC20040 8FB40010 000320C0 
00031940 0040F809 00642023 0040F021 8FA2004C 24050006 8C440000 8EC20024 
0040F809 03C0B821 8FA3004C AFA20014 8EC20024 8C640000 0040F809 24050005 
8EA30004 1C600006 8FAA0050 1460003F 3C040008 8EA30000 5060003D 3C03BF88 
00006021 10000032 00002021 2463FFFF 25290001 2508FFFF 24E70001 24C60001 
8D450004 8D440000 00035827 00057040 016E7004 00642006 00652807 306B0020 
01C42025 00AB200B 30840001 10800004 00602821 A0F30000 10000003 A0D20000 
A0F10000 A0D00000 1580000A 00000000 14AD0008 00000000 82840000 28850005 
14A00003 2484FFFC 1000FFE0 A2840000 A2800000 0501FFDD 01202021 8EA50004 
258C0001 000C1FC3 0065282A 14A00008 254A0008 8EA50004 54A3000C 3C040008 
8EA30000 0183302B 50C00008 3C040008 24890001 02843821 02E43021 24080016 
24030017 1000FFCE 240D0017 3C03BF88 AC641064 3C03BF88 AC601068 8EA40000 
00001821 000428C0 00042140 00854823 40834800 8FA70018 8FA40014 00003021 
AC870000 8FA50014 00C04021 ACA70000 8FA50010 00A62021 80840000 00641821 
40044800 0064282B 10A0FFFD 00000000 AC470000 03C81821 80630000 24C60001 
00832021 40034800 0064282B 14A0FFFD 00000000 0126202A 5080FFEB 8FA50014 
8FA40018 3C030008 AC440000 8FBF0044 3C02BF88 AC431064 3C02BF88 8FBE0040 
8FB7003C 8FB60038 8FB50034 8FB40030 8FB3002C 8FB20028 8FB10024 8FB00020 
AC431068 03E00008 27BD0048 
End Csub 

' end of program